	subroutine MT(iout, idbg, Nm, Np, dt, par, M1)
! calculate the memory function, M(t), for EXP, at t=dt

	implicit none
	integer iout, idbg
	integer Nm, Np				! array parameters
	real*8 dt
	real*8 M1(0:Np,Nm)			! Mp(t) for term p, mat m
	real*8 par(0:Np,2, Nm)			! M(t) parameters

	real*8 Ap, Bp
	integer m, p

!	write(idbg,'(a)') ' --- MT ---'	! ### TEMPORARY ###

	do m = 1, Nm
	  do p = 0, Np
	    Ap = par(p,1,m)		! Ap for term p
	    Bp = par(p,2,m)		! Bp for term p
 
! treatment of Bp=0 and Ap nonzero (a delta(t) fuction)
	    if(dt .eq. 0.d0) then
	      M1(p,m) = Ap		! Mp(t=0)=Ap for ALL terms (including Bp=0)
	    else
	      if(p .eq. 0) then
	        M1(p,m) = 0.d0		! Mp(t#0)=0 for term p with Bp=0
	      else
	        M1(p,m) = Ap*exp(-Bp*dt)	! Mp(t#0)   for term p with Bp#0
	      endif
	    endif
	  enddo	! p
	enddo	! m

	return
	end

